/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.thanos;

import club.sk1er.mods.thanos.CommandDust;
import club.sk1er.mods.thanos.CommandSnap;
import club.sk1er.mods.thanos.CommandThanosMod;
import club.sk1er.mods.thanos.DustBox;
import club.sk1er.mods.thanos.ThanosModGui;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.FileUtils;

@Mod(modid="thanosmod", version="1.0", acceptedMinecraftVersions="*")
public class ThanosMod {
    public static final String MODID = "thanosmod";
    public static final String VERSION = "1.0";
    public static ThanosMod instance;
    public HashMap<UUID, Integer> renderBlacklist = new HashMap();
    public int DISTANCE = 16;
    public int MODE = 2;
    public boolean enabled = true;
    public double speed = 1.0;
    public int RENDER_DISTANCE = 32;
    public boolean openGui;
    public boolean blending = true;
    private List<BodyPart> partList = new ArrayList<BodyPart>();
    private List<DustBox> dustBoxes = new ArrayList<DustBox>();
    private HashMap<Integer, Pos> locationPos = new HashMap();
    private HashMap<UUID, Long> cancel = new HashMap();
    private File configFile = null;
    private double snapTime = 0.01;
    private boolean snapping = false;
    private float seed;

    public ThanosMod() {
        instance = this;
        this.generate();
    }

    public static void onEntityRemoved(Entity entity) {
        instance.remove(entity);
    }

    private void generate() {
        this.partList.clear();
        this.locationPos.put(0, new Pos(-3.5, -3.5, -3.5));
        this.locationPos.put(2, new Pos(3.5, 14.0, 4.5));
        this.locationPos.put(4, new Pos(7.5, 14.0, 4.5));
        this.locationPos.put(6, new Pos(5.5, 26.0, 4.5));
        this.partList.add(new BodyPart(8, 8, 8, 8, 0.0, 0.0, 0.0, 8.0, 8.0, 0.0, 0, 0));
        this.partList.add(new BodyPart(24, 8, 8, 8, 0.0, 0.0, 7.0, 8.0, 8.0, 8.0, 1, 0));
        this.partList.add(new BodyPart(8, 0, 8, 6, 0.0, 0.0, 1.0, 8.0, 0.0, 7.0, 2, 0));
        this.partList.add(new BodyPart(16, 1, 8, 6, 0.0, 7.0, 1.0, 8.0, 7.0, 7.0, 3, 0));
        this.partList.add(new BodyPart(16, 9, 6, 6, 0.0, 1.0, 1.0, 0.0, 7.0, 7.0, 4, 0));
        this.partList.add(new BodyPart(2, 9, 6, 6, 7.0, 1.0, 6.0, 7.0, 7.0, 0.0, 5, 0));
        this.partList.add(new BodyPart(20, 20, 8, 12, 7.0, 8.0, 2.0, -1.0, 20.0, 2.0, 0, 2));
        this.partList.add(new BodyPart(32, 20, 8, 12, 0.0, 8.0, 5.0, 8.0, 20.0, 5.0, 1, 2));
        this.partList.add(new BodyPart(29, 21, 2, 10, 0.0, 9.0, 3.0, 0.0, 19.0, 5.0, 4, 2));
        this.partList.add(new BodyPart(17, 21, 2, 10, 7.0, 9.0, 4.0, 7.0, 19.0, 2.0, 5, 2));
        this.partList.add(new BodyPart(20, 16, 8, 2, 0.0, 8.0, 3.0, 8.0, 8.0, 5.0, 2, 2));
        this.partList.add(new BodyPart(28, 16, 8, 2, 0.0, 19.0, 3.0, 8.0, 19.0, 5.0, 3, 2));
        this.partList.add(new BodyPart(4, 20, 4, 12, 7.0, 20.0, 2.0, 3.0, 32.0, 2.0, 0, 5));
        this.partList.add(new BodyPart(12, 20, 4, 12, 7.0, 20.0, 5.0, 3.0, 32.0, 5.0, 1, 5));
        this.partList.add(new BodyPart(8, 20, 2, 12, 4.0, 20.0, 3.0, 4.0, 32.0, 5.0, 4, 5));
        this.partList.add(new BodyPart(0, 20, 2, 12, 7.0, 20.0, 3.0, 7.0, 32.0, 5.0, 5, 5));
        this.partList.add(new BodyPart(8, 16, 2, 2, 5.0, 31.0, 3.0, 7.0, 31.0, 5.0, 3, 5));
        this.partList.add(new BodyPart(20, 52, 4, 12, 3.0, 20.0, 2.0, -1.0, 32.0, 2.0, 0, 6));
        this.partList.add(new BodyPart(28, 52, 4, 12, 3.0, 20.0, 5.0, -1.0, 32.0, 5.0, 1, 6));
        this.partList.add(new BodyPart(30, 52, 2, 12, 0.0, 20.0, 3.0, 0.0, 32.0, 5.0, 4, 6));
        this.partList.add(new BodyPart(22, 52, 2, 12, 3.0, 20.0, 3.0, 3.0, 32.0, 5.0, 5, 6));
        this.partList.add(new BodyPart(24, 50, 2, 2, 1.0, 31.0, 3.0, 3.0, 31.0, 5.0, 3, 6));
        this.partList.add(new BodyPart(44, 20, 4, 12, 11.0, 8.0, 2.0, 7.0, 20.0, 2.0, 0, 3));
        this.partList.add(new BodyPart(52, 20, 4, 12, 11.0, 8.0, 5.0, 7.0, 20.0, 5.0, 1, 3));
        this.partList.add(new BodyPart(54, 20, 2, 12, 8.0, 8.0, 3.0, 8.0, 20.0, 5.0, 4, 3));
        this.partList.add(new BodyPart(46, 20, 2, 12, 11.0, 8.0, 3.0, 11.0, 20.0, 5.0, 5, 3));
        this.partList.add(new BodyPart(48, 18, 2, 2, 9.0, 19.0, 3.0, 11.0, 19.0, 5.0, 3, 3));
        this.partList.add(new BodyPart(44, 18, 2, 2, 9.0, 8.0, 3.0, 11.0, 8.0, 5.0, 2, 3));
        this.partList.add(new BodyPart(36, 52, 4, 12, -1.0, 8.0, 2.0, -5.0, 20.0, 2.0, 0, 4));
        this.partList.add(new BodyPart(44, 52, 4, 12, -1.0, 8.0, 5.0, -5.0, 20.0, 5.0, 1, 4));
        this.partList.add(new BodyPart(46, 52, 2, 12, -4.0, 8.0, 3.0, -4.0, 20.0, 5.0, 4, 4));
        this.partList.add(new BodyPart(38, 52, 2, 12, -1.0, 8.0, 3.0, -1.0, 20.0, 5.0, 5, 4));
        this.partList.add(new BodyPart(40, 50, 2, 2, -3.0, 19.0, 3.0, -1.0, 19.0, 5.0, 3, 4));
        this.partList.add(new BodyPart(36, 50, 2, 2, -3.0, 8.0, 3.0, -1.0, 8.0, 5.0, 2, 4));
        this.partList.add(new BodyPart(40, 8, 8, 8, 0.0, 0.0, -1.0, 8.0, 8.0, -1.0, 0, 0));
        this.partList.add(new BodyPart(56, 8, 8, 8, 0.0, 0.0, 9.0, 8.0, 8.0, 9.0, 1, 0));
        this.partList.add(new BodyPart(40, 0, 8, 6, 0.0, -1.0, 1.0, 8.0, -1.0, 7.0, 2, 0));
        this.partList.add(new BodyPart(48, 1, 8, 6, 0.0, 8.0, 1.0, 8.0, 7.0, 7.0, 3, 0));
        this.partList.add(new BodyPart(48, 9, 6, 6, -1.0, 1.0, 1.0, -1.0, 7.0, 7.0, 4, 0));
        this.partList.add(new BodyPart(34, 9, 6, 6, 8.0, 1.0, 6.0, 8.0, 7.0, 0.0, 5, 0));
        this.partList.add(new BodyPart(20, 36, 8, 12, 7.0, 8.0, 1.0, -1.0, 20.0, 1.0, 0, 2));
        this.partList.add(new BodyPart(32, 36, 8, 12, 0.0, 8.0, 6.0, 8.0, 20.0, 6.0, 1, 2));
        this.partList.add(new BodyPart(29, 37, 2, 10, -1.0, 9.0, 3.0, -1.0, 19.0, 5.0, 4, 2));
        this.partList.add(new BodyPart(17, 37, 2, 10, 8.0, 9.0, 4.0, 8.0, 19.0, 2.0, 5, 2));
        this.partList.add(new BodyPart(20, 32, 8, 2, 0.0, 7.0, 3.0, 8.0, 7.0, 5.0, 2, 2));
        this.partList.add(new BodyPart(28, 32, 8, 2, 0.0, 20.0, 3.0, 8.0, 20.0, 5.0, 3, 2));
        this.partList.add(new BodyPart(4, 36, 4, 12, 7.0, 20.0, 1.0, 3.0, 32.0, 1.0, 0, 5));
        this.partList.add(new BodyPart(12, 36, 4, 12, 7.0, 20.0, 6.0, 3.0, 32.0, 6.0, 1, 5));
        this.partList.add(new BodyPart(8, 36, 2, 12, 3.0, 20.0, 3.0, 3.0, 32.0, 5.0, 4, 5));
        this.partList.add(new BodyPart(0, 36, 2, 12, 8.0, 20.0, 3.0, 8.0, 32.0, 5.0, 5, 5));
        this.partList.add(new BodyPart(8, 32, 2, 2, 5.0, 32.0, 3.0, 7.0, 32.0, 5.0, 3, 5));
        this.partList.add(new BodyPart(4, 52, 4, 12, 3.0, 20.0, 1.0, -1.0, 32.0, 1.0, 0, 6));
        this.partList.add(new BodyPart(12, 52, 4, 12, 3.0, 20.0, 6.0, -1.0, 32.0, 6.0, 1, 6));
        this.partList.add(new BodyPart(14, 52, 2, 12, -1.0, 20.0, 3.0, -1.0, 32.0, 5.0, 4, 6));
        this.partList.add(new BodyPart(6, 52, 2, 12, 4.0, 20.0, 3.0, 4.0, 32.0, 5.0, 5, 6));
        this.partList.add(new BodyPart(8, 50, 2, 2, 1.0, 32.0, 3.0, 3.0, 32.0, 5.0, 3, 6));
        this.partList.add(new BodyPart(44, 36, 4, 12, 11.0, 8.0, 1.0, 7.0, 20.0, 1.0, 0, 3));
        this.partList.add(new BodyPart(52, 36, 4, 12, 11.0, 8.0, 6.0, 7.0, 20.0, 6.0, 1, 3));
        this.partList.add(new BodyPart(54, 36, 2, 12, 7.0, 8.0, 3.0, 7.0, 20.0, 5.0, 4, 3));
        this.partList.add(new BodyPart(46, 36, 2, 12, 12.0, 8.0, 3.0, 12.0, 20.0, 5.0, 5, 3));
        this.partList.add(new BodyPart(48, 34, 2, 2, 9.0, 20.0, 3.0, 11.0, 20.0, 5.0, 3, 3));
        this.partList.add(new BodyPart(44, 34, 2, 2, 9.0, 7.0, 3.0, 11.0, 7.0, 5.0, 2, 3));
        this.partList.add(new BodyPart(52, 52, 4, 12, -1.0, 8.0, 1.0, -5.0, 20.0, 1.0, 0, 4));
        this.partList.add(new BodyPart(60, 52, 4, 12, -1.0, 8.0, 6.0, -5.0, 20.0, 6.0, 1, 4));
        this.partList.add(new BodyPart(62, 52, 2, 12, -5.0, 8.0, 3.0, -5.0, 20.0, 5.0, 4, 4));
        this.partList.add(new BodyPart(54, 52, 2, 12, 0.0, 8.0, 3.0, 0.0, 20.0, 5.0, 5, 4));
        this.partList.add(new BodyPart(56, 50, 2, 2, -3.0, 20.0, 3.0, -1.0, 20.0, 5.0, 3, 4));
        this.partList.add(new BodyPart(52, 50, 2, 2, -3.0, 7.0, 3.0, -1.0, 7.0, 5.0, 2, 4));
    }

    public void remove(Entity entity) {
        if (!this.enabled) {
            return;
        }
        if (entity instanceof EntityPlayer && entity.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) < (double)(this.DISTANCE * this.DISTANCE)) {
            this.dust((EntityPlayer)entity);
        }
    }

    public boolean dust(EntityPlayer player) {
        Long aLong = this.cancel.get(player.func_110124_au());
        if (aLong != null && System.currentTimeMillis() - aLong < 1000L) {
            return false;
        }
        this.cancel.put(player.func_110124_au(), System.currentTimeMillis());
        ResourceLocation defaultSkinLegacy = DefaultPlayerSkin.func_177335_a();
        InputStream inputstream = null;
        IResource iresource = null;
        try {
            File file1;
            SkinManager skinManager = Minecraft.func_71410_x().func_152342_ad();
            Map textures = skinManager.field_152797_e.getTextures(player.func_146103_bH(), false);
            MinecraftProfileTexture minecraftProfileTexture = (MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN);
            File file2 = null;
            BufferedImage skin = null;
            if (minecraftProfileTexture != null && (file2 = new File(file1 = new File(skinManager.field_152796_d, minecraftProfileTexture.getHash().length() > 2 ? minecraftProfileTexture.getHash().substring(0, 2) : "xx"), minecraftProfileTexture.getHash())).exists() && ((skin = TextureUtil.func_177053_a((InputStream)(inputstream = new FileInputStream(file2)))) == null || skin.getWidth() != 64 || skin.getHeight() != 64)) {
                skin = null;
            }
            if (skin == null && (skin = TextureUtil.func_177053_a((InputStream)(inputstream = (iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(defaultSkinLegacy)).func_110527_b()))) == null) {
                return false;
            }
            for (int a = 0; a < 1; ++a) {
                for (BodyPart bodyPart : this.partList) {
                    for (int j = 0; j < bodyPart.width; ++j) {
                        for (int k = 0; k < bodyPart.height; ++k) {
                            int rawColor;
                            int alpha;
                            int x = bodyPart.texX + j;
                            int y1 = bodyPart.texY + k;
                            if (y1 >= skin.getHeight() || (alpha = (rawColor = skin.getRGB(x, y1)) >> 24 & 0xFF) == 0) continue;
                            int red = rawColor >> 16 & 0xFF;
                            int green = rawColor >> 8 & 0xFF;
                            int blue = rawColor & 0xFF;
                            double scale = 0.0625;
                            Pos relCoords = bodyPart.getCoords(j, k);
                            int tmpLayer = 0;
                            relCoords.add(0.22 / scale, 1.95 / scale, 0.22 / scale);
                            relCoords.rotate(0.0f, (float)Math.toRadians(-player.field_70177_z), 0.0f);
                            double xCoord = relCoords.x;
                            double yCoord = relCoords.y;
                            double zCoord = relCoords.z;
                            double y = 0.0;
                            int i = 0;
                            while ((double)i < player.field_70163_u) {
                                if (!player.field_70170_p.func_175623_d(new BlockPos(player.field_70165_t, (double)i, player.field_70161_v)) && player.field_70170_p.func_175623_d(new BlockPos(player.field_70165_t, (double)(i + 1), player.field_70161_v))) {
                                    y = i + 1;
                                }
                                ++i;
                            }
                            this.createPixel(player.field_70165_t + xCoord * scale, y + yCoord * scale, player.field_70161_v + zCoord * scale, red, green, blue, 255, xCoord, yCoord, zCoord, this.seed, tmpLayer);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private int floorEven(int input) {
        return input % 2 == 0 ? input : input - 1;
    }

    private void createPixel(double x, double y, double z, int red, int green, int blue, int alpha, double origPosX, double origPosY, double origPosZ, float seed, int layer) {
        this.dustBoxes.add(new DustBox((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f, x, y, z, origPosX, origPosY, origPosZ, seed, layer));
    }

    @SubscribeEvent
    public void switchWorld(WorldEvent.Unload event) {
        this.dustBoxes.clear();
        this.renderBlacklist.clear();
        this.seed = ThreadLocalRandom.current().nextFloat();
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.snapping) {
            this.snapTime += 0.05;
        }
        if (this.snapTime > 2.0) {
            this.snapping = false;
        }
        this.dustBoxes.removeIf(DustBox::onUpdate);
        HashSet<UUID> remove = new HashSet<UUID>();
        for (UUID uuid : this.renderBlacklist.keySet()) {
            Integer integer = this.renderBlacklist.get(uuid);
            if (integer == 1) {
                remove.add(uuid);
                continue;
            }
            this.renderBlacklist.put(uuid, integer - 1);
        }
        for (UUID uuid : remove) {
            this.renderBlacklist.remove(uuid);
        }
        if (this.openGui) {
            this.openGui = false;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new ThanosModGui());
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        Integer integer = this.renderBlacklist.get(event.getEntityLiving().func_110124_au());
        if (integer != null && integer > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        GlStateManager.func_179094_E();
        Tessellator instance = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = instance.func_178180_c();
        GlStateManager.func_179129_p();
        if (this.blending) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179084_k();
            GlStateManager.func_179118_c();
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179112_b((int)770, (int)771);
        for (DustBox dustBox : this.dustBoxes) {
            dustBox.render(event.getPartialTicks());
        }
        if (!this.blending) {
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandThanosMod());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandDust());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSnap());
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        this.configFile = event.getSuggestedConfigurationFile();
        this.loadConfig();
        Runtime.getRuntime().addShutdownHook(new Thread(this::saveConfig));
    }

    private void loadConfig() {
        try {
            JsonObject object = new JsonParser().parse(FileUtils.readFileToString((File)this.configFile)).getAsJsonObject();
            if (object.has("MODE")) {
                this.MODE = object.get("MODE").getAsInt();
            }
            if (object.has("spawn")) {
                this.DISTANCE = object.get("spawn").getAsInt();
            }
            if (object.has("render")) {
                this.RENDER_DISTANCE = object.get("render").getAsInt();
            }
            if (object.has("blending")) {
                this.blending = object.get("blending").getAsBoolean();
            }
            if (object.has("enabled")) {
                this.enabled = object.get("enabled").getAsBoolean();
            }
            if (object.has("speed")) {
                this.speed = object.get("speed").getAsDouble();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveConfig() {
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("MODE", (Number)this.MODE);
            jsonObject.addProperty("spawn", (Number)this.DISTANCE);
            jsonObject.addProperty("render", (Number)this.RENDER_DISTANCE);
            jsonObject.addProperty("blending", Boolean.valueOf(this.blending));
            jsonObject.addProperty("enabled", Boolean.valueOf(this.enabled));
            jsonObject.addProperty("speed", (Number)this.speed);
            FileUtils.writeStringToFile((File)this.configFile, (String)jsonObject.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void snap() {
        this.snapping = true;
        this.snapTime = 0.01;
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.snapping) {
            double a = 0.5 * this.snapTime;
            int mag = (int)Math.min(255.0, 255.0 * Math.abs(Math.pow(2.0, -a)));
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            Gui.func_73734_a((int)0, (int)0, (int)scaledResolution.func_78326_a(), (int)scaledResolution.func_78328_b(), (int)new Color(255, 255, 255, mag).getRGB());
        }
    }

    class Pos {
        double x;
        double y;
        double z;

        public Pos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void rotate(float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
            double tz;
            double ty;
            double tx;
            if (rotateAngleX != 0.0f) {
                tx = this.x;
                ty = this.y;
                tz = this.z;
                this.x = tx * (double)MathHelper.func_76134_b((float)rotateAngleX) - ty * (double)MathHelper.func_76126_a((float)rotateAngleX);
                this.y = tx * (double)MathHelper.func_76126_a((float)rotateAngleX) + ty * (double)MathHelper.func_76134_b((float)rotateAngleX);
                this.z = tz;
            }
            if (rotateAngleY != 0.0f) {
                tx = this.x;
                ty = this.y;
                tz = this.z;
                this.x = tx * (double)MathHelper.func_76134_b((float)rotateAngleY) + tz * (double)MathHelper.func_76126_a((float)rotateAngleY);
                this.y = ty;
                this.z = -tx * (double)MathHelper.func_76126_a((float)rotateAngleY) + tz * (double)MathHelper.func_76134_b((float)rotateAngleY);
            }
            if (rotateAngleZ != 0.0f) {
                tx = this.x;
                ty = this.y;
                tz = this.z;
                this.x = tx;
                this.y = ty * (double)MathHelper.func_76134_b((float)rotateAngleZ) - tz * (double)MathHelper.func_76126_a((float)rotateAngleZ);
                this.z = ty * (double)MathHelper.func_76126_a((float)rotateAngleZ) + tz * (double)MathHelper.func_76134_b((float)rotateAngleZ);
            }
        }

        public String toString() {
            return "Pos{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
        }

        public void add(double xCoord, double yCoord, double zCoord) {
            this.x += xCoord;
            this.y += yCoord;
            this.z += zCoord;
        }

        public void invert() {
            this.multiply(-1.0, -1.0, -1.0);
        }

        public void multiply(double xMult, double yMult, double zMult) {
            this.x *= xMult;
            this.y *= yMult;
            this.z *= zMult;
        }
    }

    class BodyPart {
        public final int side;
        public final int part;
        private int texX;
        private int texY;
        private int width;
        private int height;
        private double startX;
        private double startY;
        private double startZ;
        private double endX;
        private double endY;
        private double endZ;

        public BodyPart(int texX, int texY, int width, int height, double startX, double startY, double startZ, double endX, double endY, double endZ, int side, int part) {
            this.texX = texX;
            this.texY = texY;
            this.width = width;
            this.height = height;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.endX = endX;
            this.endY = endY;
            this.endZ = endZ;
            this.side = side;
            this.part = part;
        }

        public Pos getCoords(double texOne, double texTwo) {
            double newZ;
            double newY;
            double newX;
            if (this.startX == this.endX) {
                newX = this.startX;
                newY = this.startY + (this.endY - this.startY) * (texTwo / (double)this.height);
                newZ = this.startZ + (this.endZ - this.startZ) * (texOne / (double)this.width);
            } else if (this.startY == this.endY) {
                newX = this.startX + (this.endX - this.startX) * (texOne / (double)this.width);
                newY = this.startY;
                newZ = this.startZ + (this.endZ - this.startZ) * (texTwo / (double)this.height);
            } else {
                newX = this.startX + (this.endX - this.startX) * (texOne / (double)this.width);
                newY = this.startY + (this.endY - this.startY) * (texTwo / (double)this.height);
                newZ = this.startZ;
            }
            Pos pos = new Pos(newX, newY, newZ);
            pos.multiply(-1.0, -1.0, -1.0);
            return pos;
        }
    }
}

